﻿<?php include "ob/db.php"; ?>
<?php include "ob/kontrol.php" ?>
<?php include "ob/ayarlar.php"; ?>
<!DOCTYPE html>
<html lang="tr">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title><?php echo $ayar_cek['firma_adi'] ?></title>

	<!-- Global stylesheets -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
	<link href="global_assets/css/icons/icomoon/styles.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/bootstrap_limitless.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/layout.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/components.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/colors.min.css" rel="stylesheet" type="text/css">
	<link rel="stylesheet" href="assets/css/sweetalert.css">
	<!-- /global stylesheets -->

	<!-- Core JS files -->
	<script src="global_assets/js/main/jquery.min.js"></script>
	<script src="global_assets/js/main/bootstrap.bundle.min.js"></script>
	<script src="global_assets/js/plugins/loaders/blockui.min.js"></script>
	<script src="global_assets/js/plugins/ui/slinky.min.js"></script>
	<!-- /core JS files -->

	<!-- Theme JS files -->
	
	<script src="global_assets/js/plugins/forms/inputs/inputmask.js"></script>
	<script src="global_assets/js/plugins/forms/styling/switchery.min.js"></script>
	<script src="global_assets/js/plugins/ui/sticky.min.js"></script>
	<script src="global_assets/js/plugins/forms/selects/select2.min.js"></script>
	<script src="assets/js/app.js"></script>
    <script src="global_assets/js/demo_pages/navbar_multiple_sticky.js"></script>
    <script src="global_assets/js/demo_pages/form_select2.js"></script>
    <script src="global_assets/js/plugins/forms/styling/uniform.min.js"></script>
    <script src="assets/js/sweetalert.min.js"></script>
	<!-- /theme JS files -->
</head>
<body>
	<?php include "lib/navbar.php" ?>
	<?php include "lib/menu.php" ?>
	<div class="page-content pt-10">
		<div class="content-wrapper">
			<div class="content">
				<div class="card">
					<div class="card-header bg-light header-elements-inline">
						<h5 class="card-title"><i class="icon-coins"></i> Banka Hesabı Ekleme</h5>
						<div class="header-elements">
							<div class="list-icons">
		                		<a class="list-icons-item" data-action="collapse"></a>
		                		<a class="list-icons-item" data-action="reload"></a>
		                		<a class="list-icons-item" data-action="remove"></a>
		                	</div>
	                	</div>
					</div>
					<form action="" method="POST" id="add" onsubmit="return false;">
						<div class="card-body gri">
							<div class="row">
								<div class="col-md-12">
									<div class="form-group">
										<div class="row">
											<div class="col-md-3">
												<label>Banka Adı <small class="text-danger">(*)</small></label>
												<input type="text" name="banka_adi" class="form-control degerBuyuk">
											</div>
											<div class="col-md-3">
												<label>Şube Adı <small class="text-danger">(*)</small></label>
												<input type="text" name="sube_adi" class="form-control degerBuyuk">
											</div>
											<div class="col-md-2">
												<label>Hesap No <small class="text-danger">(*)</small></label>
												<input type="text" name="hesap_no" class="form-control degerBuyuk">
											</div>
											<div class="col-md-2">
												<label>IBAN <small class="text-danger">(*)</small></label>
												<input type="text" name="iban" class="form-control degerBuyuk" data-mask="TR99-9999-9999-9999-9999-9999-99">
											</div>
											<div class="col-md-2">
												<label>POS</label>
												<select name="pos" class="form-control select-search">
													<option value="" selected="">Seçim Yapın...</option>
													<option value="1">HAYIR</option>
													<option value="2">EVET</option>
												</select>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="card-footer">
							<div class="text-right">
								<button type="submit" onclick="bankaekle();" class="btn btn-primary">Bilgileri Kaydet</button>
							</div>
						</div>
					</form>
				</div>
			</div>
			<div class="bosluk"></div>
		</div>
	</div>
	<?php include "ob/footer.php" ?>
	<script type="text/javascript">
		$('.degerBuyuk').keyup(function(){
		    this.value=this.value.toUpperCase();
		});
	</script>
	<script type="text/javascript">
		function bankaekle(){
			var deger = $("#add").serialize();
			$.ajax({
				type	: "POST",
				data 	: deger,
				url 	: "bankaadd.php",
				success	: function(sonuc){
					if ($.trim(sonuc) == "banka") {
						sweetAlert('DİKKAT!', 'Banka Adı Yazmadınız...','error');
					} else if ($.trim(sonuc) == "sube") {
						sweetAlert('DİKKAT!', 'Şube Adı Yazmadınız...','error');
					} else if ($.trim(sonuc) == "hesap") {
						sweetAlert('DİKKAT!', 'Hesap No Yazmadınız...','error');
					} else if ($.trim(sonuc) == "iban") {
						sweetAlert('DİKKAT!', 'IBAN No Yazmadınız...','error');
					} else if ($.trim(sonuc) == "pos") {
						sweetAlert('DİKKAT!', 'POS Seçimi Yapmadınız...','error');
					} else if ($.trim(sonuc) == "hata") {
						sweetAlert('Hata', 'hatalı','error');
					} else if ($.trim(sonuc) == "ok") {
						swal({
						  title: "Başarılı!",
						  text: "Banka Hesabı Oluşturuldu...",
						  type: "success",
						  confirmButtonText: "Tamam"
						},
						function(isConfirm){
						  if (isConfirm) {
						    window.location.href = "BankaListe";
						  }
						});
					}
				}
			});
		} 
	</script>
</body>
</html>