<?php include "ob/db.php"; ?>
<?php include "ob/kontrol.php" ?>
<?php include "ob/ayarlar.php"; ?>
<!DOCTYPE html>
<html lang="tr">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title><?php echo $ayar_cek['firma_adi'] ?></title>

	<!-- Global stylesheets -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
	<link href="global_assets/css/icons/icomoon/styles.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/bootstrap_limitless.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/layout.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/components.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/colors.min.css" rel="stylesheet" type="text/css">
	<link rel="stylesheet" href="assets/css/sweetalert.css">
	<!-- /global stylesheets -->

	<!-- Core JS files -->
	<script src="global_assets/js/main/jquery.min.js"></script>
	<script src="global_assets/js/main/bootstrap.bundle.min.js"></script>
	<script src="global_assets/js/plugins/loaders/blockui.min.js"></script>
	<script src="global_assets/js/plugins/ui/slinky.min.js"></script>
	<!-- /core JS files -->

	<!-- Theme JS files -->
	
	<script src="global_assets/js/plugins/forms/inputs/inputmask.js"></script>
	<script src="global_assets/js/plugins/forms/styling/switchery.min.js"></script>
	<script src="global_assets/js/plugins/ui/sticky.min.js"></script>
	<script src="global_assets/js/plugins/forms/selects/select2.min.js"></script>
	<script src="assets/js/app.js"></script>
    <script src="global_assets/js/demo_pages/navbar_multiple_sticky.js"></script>
    <script src="global_assets/js/demo_pages/form_select2.js"></script>
    <script src="global_assets/js/plugins/forms/styling/uniform.min.js"></script>
    <script src="assets/js/sweetalert.min.js"></script>
	<!-- /theme JS files -->
</head>
<body>
	<?php include "lib/navbar.php" ?>
	<?php include "lib/menu.php" ?>
	<div class="page-content pt-10">
		<div class="content-wrapper">
			<div class="content">
				<form action="" method="POST" id="add" onsubmit="return false;">
					<div class="card">
						<div class="card-header bg-light header-elements-inline">
							<h5 class="card-title"><i class="icon-car f24"></i> Araç Bilgileri</h5>
							<div class="header-elements">
								<div class="list-icons">
			                		<a class="list-icons-item" data-action="collapse"></a>
			                		<a class="list-icons-item" data-action="reload"></a>
			                		<a class="list-icons-item" data-action="remove"></a>
			                	</div>
		                	</div>
						</div>
						<div class="card-body gri">
							<div class="row">
								<div class="col-md-4">
									<div class="form-group">
										<label>Araç Plaka <small class="text-danger">(*)</small></label>
										<input type="text" name="arac_plaka" class="form-control degerBuyuk">
									</div>
									<div class="form-group">
										<label>Şase No</label>
										<input type="text" name="sase_no" class="form-control degerBuyuk">
									</div>
									<div class="form-group">
										<label>Motor No</label>
										<input type="text" name="motor_no" class="form-control degerBuyuk">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label>Araç Türü <small class="text-danger">(*)</small></label>
										<select name="arac_turu" id="tur" class="form-control select-search">
											<option value="">Seçim Yap...</option>
											<?php
                                            $tur = $db->prepare("SELECT * FROM ob_stok_turu");
                                            $tur->execute(array());
                                            $turne = $tur->fetchAll(PDO::FETCH_ASSOC);
                                            foreach ($turne as $turlist) { ?>
                                                <option value="<?php echo $turlist['stok_turu_id']; ?>"><?php echo $turlist['stok_turu_ad']; ?></option>
                                            <?php } ?>
										</select>
									</div>
									<div class="form-group">
										<label>Araç Marka</label>
										<select name="arac_marka" id="marka" class="form-control select-search">
											<option value="">Önce Araç Türü Seçin...</option>
										</select>
									</div>
									<div class="form-group">
										<label>Araç Model</label>
										<select name="arac_model" id="model" class="form-control select-search">
											<option value="">Önce Marka Seçin...</option>
										</select>
									</div>
									<div class="form-group">
										<label>Model Yılı <small class="text-danger">(*)</small></label>
										<select name="model_yili" class="form-control select-search">
											<option value="">Seçim yap...</option>
											<?php
                                            $modelyili = $db->prepare("SELECT * FROM ob_model_yili");
                                            $modelyili->execute(array());
                                            $modelyiline = $modelyili->fetchAll(PDO::FETCH_ASSOC);
                                            foreach ($modelyiline as $modelyililist) { ?>
                                                <option value="<?php echo $modelyililist['id']; ?>"><?php echo $modelyililist['yil']; ?></option>
                                            <?php } ?>
										</select>
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label>Yakıt Türü <small class="text-danger">(*)</small></label>
										<select name="yakit_turu" class="form-control select-search">
											<option value="">Seçim yap...</option>
											<?php
                                            $yakit = $db->prepare("SELECT * FROM ob_yakit_turu");
                                            $yakit->execute(array());
                                            $yakitne = $yakit->fetchAll(PDO::FETCH_ASSOC);
                                            foreach ($yakitne as $yakitlist) { ?>
                                                <option value="<?php echo $yakitlist['id']; ?>"><?php echo $yakitlist['yakit']; ?></option>
                                            <?php } ?>
										</select>
									</div>
									<div class="form-group">
										<label>Araç Rengi <small class="text-danger">(*)</small></label>
										<select name="arac_renk" class="form-control select-search">
											<option value="">Seçim yap...</option>
											<?php
                                            $renk = $db->prepare("SELECT * FROM ob_arac_renk");
                                            $renk->execute(array());
                                            $renkne = $renk->fetchAll(PDO::FETCH_ASSOC);
                                            foreach ($renkne as $renklist) { ?>
                                                <option value="<?php echo $renklist['id']; ?>"><?php echo $renklist['renk']; ?></option>
                                            <?php } ?>
										</select>
									</div>
									<div class="form-group">
										<label>Araç Vites Türü <small class="text-danger">(*)</small></label>
										<select name="vites_turu" class="form-control select-search">
											<option value="">Seçim yap...</option>
											<?php
                                            $vites = $db->prepare("SELECT * FROM ob_vites_turu");
                                            $vites->execute(array());
                                            $vitesne = $vites->fetchAll(PDO::FETCH_ASSOC);
                                            foreach ($vitesne as $viteslist) { ?>
                                                <option value="<?php echo $viteslist['id']; ?>"><?php echo $viteslist['vites']; ?></option>
                                            <?php } ?>
										</select>
									</div>
									<div class="form-group">
										<label>Kasa Tipi <small class="text-danger">(*)</small></label>
										<select name="kasa_turu" class="form-control select-search">
											<option value="">Seçim yap...</option>
											<?php
                                            $kasa = $db->prepare("SELECT * FROM ob_kasa_turu");
                                            $kasa->execute(array());
                                            $kasane = $kasa->fetchAll(PDO::FETCH_ASSOC);
                                            foreach ($kasane as $kasalist) { ?>
                                                <option value="<?php echo $kasalist['id']; ?>"><?php echo $kasalist['kasa']; ?></option>
                                            <?php } ?>
										</select>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="card">
						<div class="card-header bg-light header-elements-inline">
							<h5 class="card-title"><i class="icon-ticket f24"></i> Diğer Bilgiler</h5>
							<div class="header-elements">
								<div class="list-icons">
			                		<a class="list-icons-item" data-action="collapse"></a>
			                		<a class="list-icons-item" data-action="reload"></a>
			                		<a class="list-icons-item" data-action="remove"></a>
			                	</div>
		                	</div>
						</div>
						<div class="card-body gri">
							<div class="row">
								<div class="col-md-12">
									<div class="form-group">
										<div class="row">
											<div class="col-md-3">
												<label>Alış Fiyatı <small class="text-danger">(*)</small></label>
												<input type="text" name="alis" class="form-control">
											</div>
											<div class="col-md-3">
												<label>Satış Fiyatı <small class="text-danger">(*)</small></label>
												<input type="text" name="satis" class="form-control">
											</div>
											<div class="col-md-3">
												<label>ilgili Kişi <small class="text-danger">(*)</small></label>
												<input type="text" name="ilgili" class="form-control degerBuyuk">
											</div>
											<div class="col-md-3">
												<label>ilgili Telefon <small class="text-danger">(*)</small></label>
												<input type="text" name="ilgili_telefon" class="form-control" data-mask="(999) 999-9999">
											</div>
										</div>
										<div class="cizgileme"></div>
									</div>
									<div class="form-group">
										<textarea name="bilgi" class="form-control degerBuyuk"></textarea>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="text-right">
						<button type="reset" class="btn btn-secondary">Temizle</button>
						<button type="submit" onclick="aracekle();" class="btn btn-primary">Bilgileri Kaydet</button>
					</div>
				</form>
			</div>
			<div class="bosluk"></div>
		</div>
	</div>
	<?php include "ob/footer.php" ?>
	<script type="text/javascript">
		$('.degerBuyuk').keyup(function(){
		    this.value=this.value.toUpperCase();
		});
	</script>
	<script type="text/javascript">
		$(document).ready(function(){
	    $('#tur').on('change', function(){
	        var turID = $(this).val();
	        if(turID){
	            $.ajax({
	                type:'POST',
	                url:'markamodel.php',
	                data:'stok_turu_id='+turID,
	                success:function(html){
	                    $('#marka').html(html);
	                    $('#model').html('<option value="">Önce Marka Seçin...</option>'); 
	                }
	            }); 
	        }else{
	            $('#marka').html('<option value="">Önce Stok Türü Seçin...</option>');
	            $('#model').html('<option value="">Önce Marka Seçin...</option>'); 
	        }
	    });
	    
	    $('#marka').on('change', function(){
	        var MarkaID = $(this).val();
	        if(MarkaID){
	            $.ajax({
	                type:'POST',
	                url:'markamodel.php',
	                data:'stok_marka_id='+MarkaID,
	                success:function(html){
	                    $('#model').html(html);
	                }
	            }); 
	        }else{
	            $('#model').html('<option value="">Önce Marka Seçin...</option>'); 
	        }
	    });
	});
	</script>	
	<script type="text/javascript">
		function aracekle(){
			var deger = $("#add").serialize();
			$.ajax({
				type	: "POST",
				data 	: deger,
				url 	: "ikincieladd.php",
				success	: function(sonuc){
					if ($.trim(sonuc) == "plaka") {
						sweetAlert('DİKKAT!', 'Araç Plakası Yazmadınız...','warning');
					} else if ($.trim(sonuc) == "sase") {
						sweetAlert('DİKKAT!', 'Araç Şase No Yazmadınız...','warning');
					} else if ($.trim(sonuc) == "tur") {
						sweetAlert('DİKKAT!', 'Araç Türü Seçmediniz...','warning');
					} else if ($.trim(sonuc) == "marka") {
						sweetAlert('DİKKAT!', 'Araç Marka Seçmediniz....','warning');
					} else if ($.trim(sonuc) == "model") {
						sweetAlert('DİKKAT!', 'Araç Modeli Seçmediniz....','warning');
					} else if ($.trim(sonuc) == "yil") {
						sweetAlert('DİKKAT!', 'Araç Model Yılı Seçmediniz...','warning');
					} else if ($.trim(sonuc) == "yakit") {
						sweetAlert('DİKKAT!', 'Araç Yakıt Türü Seçmediniz....','warning');
					} else if ($.trim(sonuc) == "renk") {
						sweetAlert('DİKKAT!', 'Araç Rengi Seçmediniz....','warning');
					} else if ($.trim(sonuc) == "vites") {
						sweetAlert('DİKKAT!', 'Araç Vites Türü Seçmediniz...','warning');
					} else if ($.trim(sonuc) == "kasa") {
						sweetAlert('DİKKAT!', 'Araç Kasa Türü Seçmediniz...','warning');
					} else if ($.trim(sonuc) == "alis") {
						sweetAlert('DİKKAT', 'Alış Fiyatı Girmediniz...','warning');
					} else if ($.trim(sonuc) == "satis") {
						sweetAlert('DİKKAT', 'Satış Fiyatı Girmediniz...','warning');
					} else if ($.trim(sonuc) == "ilgili") {
						sweetAlert('DİKKAT', 'ilgili Kişi Yazmadınız...','warning');
					} else if ($.trim(sonuc) == "ilgilitel") {
						sweetAlert('DİKKAT', 'ilgili Kişi Telefon No Yazmadınız...','warning');
					} else if ($.trim(sonuc) == "bilgi") {
						sweetAlert('DİKKAT', 'Araç Bilgisi Girmediniz...','warning');
					} else if ($.trim(sonuc) == "hata") {
						sweetAlert('Hata', 'hatalı','error');
					} else if ($.trim(sonuc) == "ok") {
						swal({
						  title: "Başarılı!",
						  text: "ikinci El Araç Kaydı Oluşturuldu...",
						  type: "success",
						  confirmButtonText: "Tamam"
						},
						function(isConfirm){
						  if (isConfirm) {
						    window.location.href = "ikinciElAraclar";
						  }
						});
					}
				}
			});
		} 
	</script>
	<script type="text/javascript">
		$('body').on('keydown', 'input, select', function(e) {
		    if (e.key === "Enter") {
		        var self = $(this), form = self.parents('form:eq(0)'), focusable, next;
		        focusable = form.find('input,select,textarea').filter(':visible');
		        next = focusable.eq(focusable.index(this)+1);
		        if (next.length) {
		            next.focus();
		        } else {
		            form.submit();
		        }
		        return false;
		    }
		});
	</script>
</body>
</html>